package com.xebialabs.deployit.plugin.api.reflect;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class DeployableGenerator {
    public static void init() {
        generateDeployables();
    }

    static void generateDeployables() {
        List<Descriptor> generatedDeployableDescriptors = newArrayList();
        for(Descriptor descriptor : newArrayList(DescriptorRegistry.getDescriptors())) {
            if(descriptor.shouldGenerateDeployableType()) {
	            Descriptor generated = Descriptor.from(descriptor);
	            generatedDeployableDescriptors.add(generated);
	            DescriptorRegistry.register(generated);
            }
        }

        for(Descriptor d : generatedDeployableDescriptors) {
            d.initHierarchy();
        }
    }


}
