/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.artifact;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.utils.TFileUtils;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TFileWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Artifacts {
    public static Map<String, Pattern> patternMap = new MapMaker().makeComputingMap((Function)new Function<String, Pattern>(){

        public Pattern apply(String string) {
            return Pattern.compile(string, 6);
        }
    });
    private static final Logger logger = LoggerFactory.getLogger(Artifacts.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanPlaceholders(SourceArtifact sourceArtifact, PlaceholderScanner placeholderScanner) {
        Preconditions.checkArgument((sourceArtifact.getFile() != null ? 1 : 0) != 0, (Object)(sourceArtifact + " has no file"));
        Preconditions.checkArgument((boolean)(sourceArtifact.getFile() instanceof LocalFile), (Object)("Cannot scan for placeholders in " + sourceArtifact + " because its file is a " + sourceArtifact.getFile().getClass().getName() + " and not a " + LocalFile.class.getName()));
        sourceArtifact.setPlaceholders(Sets.newTreeSet());
        if (sourceArtifact.hasProperty("scanPlaceholders") && !((Boolean)sourceArtifact.getProperty("scanPlaceholders")).booleanValue()) {
            return;
        }
        TFile tFile = Artifacts.toTFile(sourceArtifact.getFile());
        try {
            Artifacts.doScanPlaceholders(sourceArtifact, tFile, placeholderScanner);
        }
        finally {
            TFileUtils.umountQuietly(tFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScanPlaceholders(SourceArtifact sourceArtifact, TFile tFile, PlaceholderScanner placeholderScanner) {
        if (Artifacts.shouldExcludeFile(tFile, sourceArtifact.getExcludeFileNamesRegex())) {
            return;
        }
        if (tFile.isDirectory()) {
            try {
                for (TFile tFile2 : tFile.listFiles()) {
                    Artifacts.doScanPlaceholders(sourceArtifact, tFile2, placeholderScanner);
                }
            }
            finally {
                TFileUtils.umountQuietly(tFile);
            }
        } else if (Artifacts.isTextFile(tFile, sourceArtifact.getTextFileNamesRegex())) {
            sourceArtifact.getPlaceholders().addAll(Artifacts.readPlaceholders(tFile, placeholderScanner));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readPlaceholders(TFile tFile, PlaceholderScanner placeholderScanner) {
        Set<String> set;
        TFileReader tFileReader = null;
        try {
            logger.trace("Reading placeholders from file {}", (Object)tFile.getPath());
            tFileReader = new TFileReader(tFile);
            set = placeholderScanner.scan((Reader)tFileReader);
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeIOException("Cannot scan for placeholders in " + tFile, (Throwable)iOException);
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("Cannot scan for placeholders in " + tFile, runtimeException);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(tFileReader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)tFileReader);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, PlaceholderReplacer placeholderReplacer) {
        block9: {
            if (derivedArtifact.getSourceArtifact() == null) {
                derivedArtifact.setFile(null);
            } else {
                Preconditions.checkArgument((derivedArtifact.getSourceArtifact().getFile() != null ? 1 : 0) != 0, (String)"%s has no file", (Object[])new Object[]{derivedArtifact.getSourceArtifact()});
                Preconditions.checkArgument((boolean)(derivedArtifact.getSourceArtifact().getFile() instanceof LocalFile), (String)"Cannot replace placeholders in %s because its file is not a LocalFile but a %s", (Object[])new Object[]{derivedArtifact.getSourceArtifact(), derivedArtifact.getSourceArtifact().getFile().getClass().getName()});
                TFile tFile = Artifacts.toTFile(derivedArtifact.getSourceArtifact().getFile());
                try {
                    boolean bl;
                    boolean bl2 = bl = tFile.isFile() && !Artifacts.isTextFile(tFile, Artifacts.getTextFileNamesRegex(derivedArtifact));
                    if (derivedArtifact.getPlaceholders().isEmpty() || bl) {
                        derivedArtifact.setFile(derivedArtifact.getSourceArtifact().getFile());
                        break block9;
                    }
                    TFile tFile2 = Artifacts.getOutputFile(derivedArtifact);
                    try {
                        Artifacts.doReplacePlaceholders(derivedArtifact, tFile, tFile2, placeholderReplacer);
                        File file = Artifacts.saveArchive(tFile2);
                        derivedArtifact.setFile(LocalFile.valueOf((File)file));
                    }
                    finally {
                        TFileUtils.umountQuietly(tFile2);
                    }
                }
                finally {
                    TFileUtils.umountQuietly(tFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReplacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, TFile tFile, TFile tFile2, PlaceholderReplacer placeholderReplacer) {
        boolean bl = Artifacts.shouldExcludeFile(tFile, Artifacts.getExcludeFileNamesRegex(derivedArtifact));
        if (!bl && tFile.isDirectory()) {
            try {
                try {
                    tFile2.mkdir(false);
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException("Cannot create directory " + tFile2, (Throwable)iOException);
                }
                for (TFile tFile3 : tFile.listFiles()) {
                    TFile tFile4 = new TFile((File)tFile2, tFile3.getName());
                    Artifacts.doReplacePlaceholders(derivedArtifact, tFile3, tFile4, placeholderReplacer);
                }
            }
            finally {
                TFileUtils.umountQuietly(tFile);
                TFileUtils.umountQuietly(tFile2);
            }
        }
        if (!bl && Artifacts.isTextFile(tFile, Artifacts.getTextFileNamesRegex(derivedArtifact))) {
            Artifacts.replace(tFile, tFile2, placeholderReplacer, derivedArtifact.getPlaceholders());
        } else {
            try {
                tFile.cp_rp((File)tFile2);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot copy " + tFile + " to " + tFile2, (Throwable)iOException);
            }
        }
    }

    private static void replace(TFile tFile, TFile tFile2, PlaceholderReplacer placeholderReplacer, Map<String, String> map) {
        TFileReader tFileReader = null;
        TFileWriter tFileWriter = null;
        try {
            tFileReader = new TFileReader(tFile);
            tFileWriter = new TFileWriter(tFile2);
            placeholderReplacer.replace((Reader)tFileReader, (Writer)tFileWriter, map);
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeIOException("Cannot copy " + tFile + " to " + tFile2 + " while replacing placeholders", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(tFileReader);
                Closeables.closeQuietly(tFileWriter);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)tFileReader);
        Closeables.closeQuietly((Closeable)tFileWriter);
    }

    private static final TFile getOutputFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        OverthereFile overthereFile = derivedArtifact.getSourceArtifact().getFile().getParentFile();
        Random random = new Random();
        String string = derivedArtifact.getName();
        while (true) {
            OverthereFile overthereFile2;
            if (!(overthereFile2 = overthereFile.getFile(string)).exists()) {
                overthereFile2.mkdir();
                return Artifacts.toTFile(overthereFile2.getFile(derivedArtifact.getSourceArtifact().getFile().getName()));
            }
            string = derivedArtifact.getName() + Math.abs(random.nextInt());
        }
    }

    private static File saveArchive(TFile tFile) {
        if (tFile.isArchive() && tFile.getEnclArchive() == null && tFile.isDirectory()) {
            try {
                TFile.umount((TFile)tFile);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot write archive " + tFile, (Throwable)iOException);
            }
        }
        return new File(tFile.getPath());
    }

    private static boolean shouldExcludeFile(TFile tFile, String string) {
        if (Strings.emptyToNull((String)string) == null) {
            return false;
        }
        Pattern pattern = patternMap.get(string);
        Matcher matcher = pattern.matcher(tFile.getPath());
        boolean bl = matcher.matches();
        if (bl) {
            logger.debug("Excluding file {} from scanning", (Object)tFile);
        }
        return bl;
    }

    private static String getExcludeFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getExcludeFileNamesRegex();
    }

    private static boolean isTextFile(TFile tFile, String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Regex is null");
        Pattern pattern = patternMap.get(string);
        Matcher matcher = pattern.matcher(tFile.getName());
        boolean bl = matcher.matches();
        logger.debug("Determined {} to be a {} file", (Object)tFile.getName(), (Object)(bl ? "text" : "binary"));
        return bl;
    }

    private static String getTextFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getTextFileNamesRegex();
    }

    private static TFile toTFile(OverthereFile overthereFile) {
        return new TFile(((LocalFile)overthereFile).getFile());
    }
}

