/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.execution;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class InterleavedPlan
implements Plan {
    private List<Delta> deltas;
    private ListMultimap<Integer, DeploymentStep> steps;

    InterleavedPlan(List<Delta> list) {
        this.deltas = Collections.unmodifiableList(list);
        this.steps = Multimaps.unmodifiableListMultimap((ListMultimap)ArrayListMultimap.create());
    }

    InterleavedPlan(Delta ... deltaArray) {
        this(Lists.newArrayList((Object[])deltaArray));
    }

    InterleavedPlan(List<Delta> list, ListMultimap<Integer, DeploymentStep> listMultimap) {
        this.deltas = Collections.unmodifiableList(list);
        this.steps = Multimaps.unmodifiableListMultimap(listMultimap);
    }

    public List<Delta> getDeltas() {
        return this.deltas;
    }

    public ListMultimap<Integer, DeploymentStep> getStepsMap() {
        return this.steps;
    }

    @Override
    public List<DeploymentStep> getSteps() {
        TreeSet treeSet = new TreeSet(this.steps.keySet());
        ArrayList arrayList = Lists.newArrayList();
        for (Integer n : treeSet) {
            arrayList.addAll(this.steps.get((Object)n));
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return InterleavedPlan.class.getName();
    }
}

