package com.xebialabs.deployit.plugin.api.deployment.execution;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.unmodifiableList;

import java.util.ArrayList;
import java.util.List;

/**
 * A {@link CompositePlan} which executes all sub-plans in serial.
 */
public class SerialPlan extends CompositePlan {
    public SerialPlan(Plan... plans) {
        super(plans);
    }

    public SerialPlan(List<Plan> plans) {
        super(plans);
    }

	/**
	 * Returns all the steps of all the (serial) sub-plans. The steps are not re-ordered but are just the concatenation of steps of all sub-plans,
	 * because each of the sub-plans is serially executed after the previous sub-plan.
	 *
	 * @return the steps of all the sub-plans.
	 */
	@Override
	public List<DeploymentStep> getSteps() {
		ArrayList<DeploymentStep> steps = newArrayList();
		for (Plan plan : plans) {
			steps.addAll(plan.getSteps());
		}
		return unmodifiableList(steps);
	}
}
