package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.validation.NoSelfReference;

import java.util.List;
import java.util.Set;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
@Metadata
@NoSelfReference(referenceField = "packages")
public class CompositePackage extends Version {

	@Property(required = false, description = "The DeploymentPackages that make up this CompositePackage.")
	private List<Version> packages = newArrayList();

	public List<Version> getPackages() {
		return packages;
	}

	@Override
	public Set<Deployable> getDeployables() {
		Set<Deployable> d = newHashSet();
		for (Version aPackage : packages) {
			d.addAll(aPackage.getDeployables());
		}
		return d;
	}
}
