package com.xebialabs.deployit.plugin.api.deployment.specification;

import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

import java.util.List;

/**
 * The specification of what should happen on the target environment in order to deploy this {@link DeployedApplication}
 */
public interface DeltaSpecification {

	/**
	 * The operation that is being executed on the {@link DeployedApplication}.
	 * @return the operation
	 */
    Operation getOperation();

	/**
	 * The {@link DeployedApplication} that is the subject of the current (un)deployment.
	 * @return the DeployedApplication
	 */
    DeployedApplication getDeployedApplication();

	/**
	 * The {@link Delta}s that were calculated for this deployment
	 * @return the list of {@link Delta}
	 */
    List<Delta> getDeltas();

}
