package com.xebialabs.deployit.plugin.api.deployment.planning;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

/**
 * Annotates a method on a {@link Deployed} that is called when Deployit wants to
 * {@link com.xebialabs.deployit.plugin.api.deployment.specification.Operation#NOOP noop} the Deployed in the middleware.
 *
 * <p>
 * The annotated method should take the following parameters:
 * <ul>
 *     <li>{@link DeploymentPlanningContext} The Planning Context</li>
 * </ul>
 *
 * The annotated method can optionally take the following parameter:
 * <ul>
 *     <li>{@link Delta} The Delta that lead to this Deployed</li>
 * </ul>
 * 
 * The annotated method should not have a return type (void).
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Noop {
}
