package com.xebialabs.deployit.plugin.api.deployment.execution;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

/**
 * A CompositePlan holds other sub-plans which are either parallellized (see: {@link ParallelPlan}) or serialized (see: {@link SerialPlan}).
 */
public abstract class CompositePlan implements Plan {
    protected List<Plan> plans;

    protected CompositePlan(Plan... plans) {
        this.plans = newArrayList(plans);
    }

    protected CompositePlan(List<Plan> plans) {
        this.plans = newArrayList(plans);
    }

	/**
	 * Gets the full list of plans.
	 * @return the full list of plans.
	 */
    public List<Plan> getPlans() {
        return plans;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }
}
