package com.xebialabs.deployit.plugin.api.boot;

import com.xebialabs.deployit.plugin.api.reflect.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Class responsible for booting all the plugins. Responsible for:
 * - Registering all the Descriptors
 * - Setting up the Global Context.
 */
public class PluginBooter {

	private static final AtomicBoolean isBooted = new AtomicBoolean(false);

	/**
	 * Boot the Deployit Plugin System. Setting everything up.
	 */
	public static void boot() {
        try {
		    boot(true);
        }  catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", re);
            throw re;
        }
	}

	/**
	 * Boot the Deployit Plugin System, but without initializing the global context with user overridden default values.
	 * Useful for tests where you want to have control which default values a CI has.
	 */
	public static void bootWithoutGlobalContext() {
		boot(false);
	}

	private synchronized static void boot(boolean withGlobalContext) {
		if (!isBooted.getAndSet(true)) {
			TypeInitializer.init();
			SyntheticInitializer.init();
			DescriptorHierarchyInitializer.init();
			DeployableGenerator.init();
			if (withGlobalContext) {
				GlobalContextInitializer.init();
			}
			PluginVersions.init();
		}
	}

    private static final Logger logger = LoggerFactory.getLogger(PluginBooter.class);
}
