/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SyntheticHelper {
    SyntheticHelper() {
    }

    static String getRequiredStringAttribute(Element element, String string) {
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        throw new IllegalArgumentException("Attribute " + string + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String string, String string2) {
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        throw new IllegalArgumentException("Attribute " + string + " not provided " + string2);
    }

    static Type getRequiredTypeAttribute(Element element, String string) {
        Type type = SyntheticHelper.getOptionalTypeAttribute(element, string);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + string + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String string, Type type) {
        String string2 = SyntheticHelper.getOptionalStringAttribute(element, string, null);
        Type type2 = type;
        if (string2 != null) {
            type2 = Type.valueOf(string2);
        }
        return type2;
    }

    static Type getOptionalTypeAttribute(Element element, String string) {
        return SyntheticHelper.getOptionalTypeAttribute(element, string, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String string, boolean bl) {
        return Boolean.valueOf(SyntheticHelper.getOptionalStringAttribute(element, string, Boolean.toString(bl)));
    }

    static String getOptionalStringAttribute(Element element, String string, String string2) {
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        return string2;
    }

    static Iterator<Element> childByName(final Element element, final Predicate<String> predicate) {
        return new Iterator<Element>(){
            private int i = 0;
            private NodeList childNodes = element.getChildNodes();
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                return this.nextIndex > this.i;
            }

            @Override
            public Element next() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                if (this.nextIndex < this.i) {
                    throw new NoSuchElementException("There are no more matching elements");
                }
                this.i = this.nextIndex;
                return (Element)this.childNodes.item(this.i);
            }

            private int findNext() {
                int n = this.i;
                while (n < this.childNodes.getLength()) {
                    Element element2;
                    if (!(this.childNodes.item(++n) instanceof Element) || !predicate.apply((Object)(element2 = (Element)this.childNodes.item(n)).getNodeName())) continue;
                    return n;
                }
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.call(iterator.next());
        }
    }

    public static interface Closure<E> {
        public void call(E var1);
    }
}

