package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;

import java.util.Map;
import java.util.regex.Pattern;

import static com.google.common.collect.Maps.newHashMap;

/**
 * Base configuration item. It contains the default annotation for the lazy configuration items out there.
 */
@SuppressWarnings("serial")
@Metadata
public abstract class BaseConfigurationItem implements ConfigurationItem, Comparable<BaseConfigurationItem> {
	protected String id = String.valueOf(System.identityHashCode(this));
	protected Type type = Type.valueOf(this.getClass());
	protected Map<String, Object> syntheticProperties = newHashMap();

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getName() {
		int indexOfLastSlash = id.lastIndexOf('/');
		if (indexOfLastSlash > -1) {
			return id.substring(indexOfLastSlash + 1);
		}
		return id;
	}

	@Override
	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	@Override
	public boolean equals(Object thatObject) {
		if (this == thatObject)
			return true;
		if (!(thatObject instanceof BaseConfigurationItem))
			return false;

		BaseConfigurationItem that = (BaseConfigurationItem) thatObject;
		return getId().equals(that.getId());
	}

	@Override
	public int compareTo(BaseConfigurationItem o) {
		return getId().compareTo(o.getId());
	}

	@Override
	public String toString() {
		if (id == null) {
			return getClass().getName() + "[id = null]";
		}
		if (Pattern.matches("[ '\"]", id)) {
			return "\"" + id + "\"";
		}
		return id;
	}

	@Override
	@Deprecated
	public Map<String, Object> getSyntheticProperties() {
		return syntheticProperties;
	}

    @Override
    @SuppressWarnings("unchecked")
    @Deprecated
	public <T> T getSyntheticProperty(String key) {
		return (T) syntheticProperties.get(key);
	}

	@Deprecated
	public boolean hasSyntheticProperty(String key) {
		return syntheticProperties.containsKey(key);
	}

	@Override
	@Deprecated
	public <T> void putSyntheticProperty(String key, T value) {
		syntheticProperties.put(key, value);
	}

	@Deprecated
	public void putSyntheticProperties(Map<String, String> properties) {
		this.syntheticProperties.putAll(properties);
	}

	@Deprecated
	public void setSyntheticProperties(Map<String, Object> additionalProperties) {
		this.syntheticProperties = additionalProperties;
	}

	@SuppressWarnings("unchecked")
    @Override
	public <T> T getProperty(String key) {
		return (T) DescriptorRegistry.getDescriptor(type).getPropertyDescriptor(key).get(this);
	}

	@Override
	public boolean hasProperty(String key) {
		return DescriptorRegistry.getDescriptor(type).getPropertyDescriptor(key) != null;
	}

	@Override
	public <T> void setProperty(String key, T value) {
		DescriptorRegistry.getDescriptor(type).getPropertyDescriptor(key).set(this, value);
	}
}
