/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import java.io.Serializable;

public class Type
implements Serializable {
    private String prefix;
    private String name;

    private Type(String prefix, String name) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        Preconditions.checkNotNull((Object)name, (Object)"type");
        this.prefix = prefix;
        this.name = name;
    }

    public static Type valueOf(Class<?> ciClass) {
        Preconditions.checkNotNull(ciClass, (Object)"Cannot get the type of a null class");
        Package ciPackage = ciClass.getPackage();
        Prefix prefix = ciPackage.getAnnotation(Prefix.class);
        Preconditions.checkNotNull((Object)prefix, (String)"Package [%s] should have an @Prefix annotation for ci-class [%s]", (Object[])new Object[]{ciPackage.getName(), ciClass.getName()});
        String simpleName = ciClass.getSimpleName();
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)simpleName), (String)"Could not get a typename for ci-class [%s]", (Object[])new Object[]{ciClass.getName()});
        return Type.valueOf(prefix.value(), simpleName);
    }

    public static Type valueOf(String typeName) {
        Preconditions.checkNotNull((Object)typeName, (Object)"Cannot get the type of a null typeName String");
        Preconditions.checkArgument((typeName.indexOf(46) != -1 ? 1 : 0) != 0, (String)"Type %s does not contain a prefix", (Object[])new Object[]{typeName});
        int indexOfLastDot = typeName.lastIndexOf(46);
        return Type.valueOf(typeName.substring(0, indexOfLastDot), typeName.substring(indexOfLastDot + 1));
    }

    public static Type valueOf(String prefix, String simpleName) {
        return new Type(prefix, simpleName);
    }

    public Descriptor getDescriptor() {
        return DescriptorRegistry.getDescriptor(this);
    }

    public boolean isSubTypeOf(Type superType) {
        return DescriptorRegistry.getSubtypes(superType).contains(this);
    }

    public boolean isSuperTypeOf(Type subType) {
        return DescriptorRegistry.getSubtypes(this).contains(subType);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type1 = (Type)o;
        return this.prefix.equals(type1.prefix) && this.name.equals(type1.name);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.prefix + "." + this.name;
    }
}

