package com.xebialabs.deployit.plugin.api.utils;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFileUtils {
	
	public static void umountQuietly(TFile file) {
		if (file != null && file.isArchive() && file.getEnclArchive() == null) {
			try {
				TFile.umount(file);
			} catch (Exception e) {
				logger.error("Couldn't umount [{}], ignoring exception.", file);
				logger.debug("Exception while umounting was: ", e);
			}
		}
	}
	
	private static final Logger logger = LoggerFactory.getLogger(TFileUtils.class);
}
