package com.xebialabs.deployit.plugin.api.deployment.planning;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation on a method of a Deployed&lt;D, C&gt;.
 * The annotated method is called when Deployit wants to
 * {@link com.xebialabs.deployit.plugin.api.deployment.specification.Operation#CREATE} the Deployed in the middleware.
 *
 * The annotated method should take the following parameters:
 * <ul>
 *     <li>{@link DeploymentPlanningContext} The Planning Context</li>
 * </ul>
 *
 * The annotated method can optionally take the following parameter:
 * <ul>
 *     <li>{@link com.xebialabs.deployit.plugin.api.deployment.specification.Delta} The Delta that lead to this Deployed</li>
 * </ul>
 *  *
 * The annotated method should not have a return type (void).
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Create {
}
