package com.xebialabs.deployit.plugin.api.deployment.execution;

import java.util.Comparator;

/**
 * Comparator that sorts {@link DeploymentStep} according to their
 * {@link com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep#getOrder()} in an ascending fashion.
 */
class StepComparator implements Comparator<DeploymentStep> {
	@Override
	public int compare(DeploymentStep o1, DeploymentStep o2) {
		return o1.getOrder() - o2.getOrder();
	}
}
