package com.xebialabs.deployit.plugin.api.boot;

import com.xebialabs.deployit.plugin.api.reflect.*;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Class responsible for booting all the plugins. Responsible for:
 * - Registering all the Descriptors
 * - Setting up the Global Context.
 */
public class PluginBooter {

	private static final AtomicBoolean isBooted = new AtomicBoolean(false);

	/**
	 * Boot the Deployit Plugin System. Setting everything up.
	 */
	public static void boot() {
		boot(true);
	}

	/**
	 * Boot the Deployit Plugin System, but without initializing the global context with user overridden default values.
	 * Useful for tests where you want to have control which default values a CI has.
	 */
	public static void bootWithoutGlobalContext() {
		boot(false);
	}

	private static void boot(boolean withGlobalContext) {
		if (!isBooted.getAndSet(true)) {
			TypeInitializer.init();
			SyntheticInitializer.init();
			DescriptorHierarchyInitializer.init();
			DeployableGenerator.init();
			if (withGlobalContext) {
				GlobalContextInitializer.init();
			}
		}
	}

}
