/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="placeholders")
@Target(value={ElementType.TYPE})
public @interface Placeholders {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Deployed<?, ?>> {
        @Override
        public void validate(Deployed<?, ?> value, ValidationContext context) {
            if (!value.hasProperty("placeholders")) {
                return;
            }
            Map placeholders = (Map)value.getProperty("placeholders");
            this.validateAllPlaceholdersSet(placeholders, context);
            if (value.getDeployable() != null) {
                Object deployable = value.getDeployable();
                if (!deployable.hasProperty("placeholders")) {
                    context.error("Deployed %s has placeholders but the Deployable not.", value.getId());
                } else {
                    Set deployablePlaceholders = (Set)deployable.getProperty("placeholders");
                    this.validatePlaceholdersAllPresent(deployablePlaceholders, placeholders, context);
                }
            }
        }

        private void validatePlaceholdersAllPresent(Set<String> source, Map<String, String> dest, ValidationContext context) {
            Set<String> destKeys = dest.keySet();
            this.wrongKeys((Set<String>)Sets.difference(source, destKeys), context, "Deployable contains placeholder %s which is not defined in deployed");
            this.wrongKeys((Set<String>)Sets.difference(destKeys, source), context, "Deployed contains placeholder %s which was not found in deployable");
        }

        private void wrongKeys(Set<String> difference, ValidationContext context, String error) {
            for (String s : difference) {
                context.error(error, s);
            }
        }

        private void validateAllPlaceholdersSet(Map<String, String> placeholders, ValidationContext context) {
            for (String s : placeholders.keySet()) {
                if (placeholders.get(s) != null && !placeholders.get(s).trim().isEmpty()) continue;
                context.error("Placeholders [%s] doesn't have a value.", s);
            }
        }
    }
}

