/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.w3c.dom.Element;

public class MethodDescriptor {
    private static final String CONTROL_TASK_DISPATCH_METHOD = "controlTaskDispatch";
    private String name;
    private Method method;
    private String description;
    private Descriptor descriptor;

    private MethodDescriptor(Descriptor descriptor, String name) {
        this.descriptor = descriptor;
        this.name = name;
    }

    private MethodDescriptor(Descriptor descriptor, Method method) {
        this.method = method;
        this.name = method.getName();
        this.descriptor = descriptor;
    }

    MethodDescriptor(MethodDescriptor copyOf, Descriptor newOwner) {
        this.method = copyOf.method;
        this.name = copyOf.name;
        this.description = copyOf.description;
        this.descriptor = newOwner;
    }

    static MethodDescriptor from(Descriptor descriptor, Method method) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(descriptor, method);
        methodDescriptor.initMetadata();
        return methodDescriptor;
    }

    static MethodDescriptor from(Descriptor descriptor, Element element) {
        String name = SyntheticHelper.getRequiredStringAttribute(element, "name");
        MethodDescriptor methodDescriptor = new MethodDescriptor(descriptor, name);
        methodDescriptor.description = SyntheticHelper.getOptionalStringAttribute(element, "description", "No description.");
        return methodDescriptor;
    }

    private void initMetadata() {
        ControlTask annotation = this.method.getAnnotation(ControlTask.class);
        this.description = annotation.description();
    }

    void verify() {
        if (this.method != null) {
            Preconditions.checkState((this.method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"ControlTask %s should not take any parameters", (Object[])new Object[]{this.getFqn()});
            Preconditions.checkState((boolean)List.class.isAssignableFrom(this.method.getReturnType()), (String)"ControlTask %s should return a List<Step>", (Object[])new Object[]{this.getFqn()});
        } else {
            Method controlTaskDispatch = this.getDispatcher();
            Preconditions.checkState((controlTaskDispatch.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)"ControlTask dispatcher %s for %s should take name parameter", (Object[])new Object[]{CONTROL_TASK_DISPATCH_METHOD, this.getFqn()});
            Preconditions.checkState((boolean)List.class.isAssignableFrom(controlTaskDispatch.getReturnType()), (String)"ControlTask dispatcher %s for %s should return a List<Step>", (Object[])new Object[]{CONTROL_TASK_DISPATCH_METHOD, this.getFqn()});
        }
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getDescription() {
        return this.description;
    }

    public Descriptor getDeclaringDescriptor() {
        return this.descriptor;
    }

    public <T> T invoke(ConfigurationItem item) {
        try {
            if (this.method == null) {
                return (T)this.getDispatcher().invoke((Object)item, this.name);
            }
            return (T)this.method.invoke((Object)item, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.name + " on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.name + " on " + item);
        }
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }

    private Method getDispatcher() {
        Class<?> clazz = this.descriptor.getClazz();
        try {
            return clazz.getMethod(CONTROL_TASK_DISPATCH_METHOD, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No ControlTask dispatcher found for " + this.name + " on " + this.descriptor, e);
        }
    }
}

