/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassUtils {
    ClassUtils() {
    }

    static <S> List<Class<? extends S>> getSuperclassChain(Class<? extends S> clazz, Class<S> superclass) {
        Set<List<Class<S>>> superclassChains = ClassUtils.getSuperclassChainsInternal(clazz, superclass, true);
        return superclassChains.isEmpty() ? null : superclassChains.iterator().next();
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassChainsInternal(Class<? extends S> clazz, Class<S> superclass, boolean oneChainSufficient) {
        Preconditions.checkNotNull(clazz, (Object)"'clazz' and 'superclass' may not be non-null");
        Preconditions.checkNotNull(superclass, (Object)"'clazz' and 'superclass' may not be non-null");
        if (!superclass.isAssignableFrom(clazz)) {
            return Collections.emptySet();
        }
        return ClassUtils.getSuperclassSubchains(clazz, superclass, oneChainSufficient, superclass.isInterface());
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassSubchains(Class<? extends S> subclass, Class<S> superclass, boolean oneChainSufficient, boolean considerInterfaces) {
        if (subclass.equals(superclass)) {
            LinkedList<Class<S>> subchain = new LinkedList<Class<S>>();
            subchain.add(subclass);
            return Collections.singleton(subchain);
        }
        HashSet supertypes = new HashSet();
        Class<S> immediateSuperclass = subclass.getSuperclass();
        if (immediateSuperclass != null) {
            supertypes.add(immediateSuperclass);
        }
        if (considerInterfaces) {
            supertypes.addAll(Arrays.asList(subclass.getInterfaces()));
        }
        HashSet subchains = new HashSet();
        for (Class clazz : supertypes) {
            Set<List<Class<S>>> subchainsFromSupertype = ClassUtils.getSuperclassSubchains(clazz, superclass, oneChainSufficient, considerInterfaces);
            if (subchainsFromSupertype.isEmpty()) continue;
            if (oneChainSufficient) {
                ClassUtils.addSubchain(subchains, subclass, subchainsFromSupertype.iterator().next());
                return subchains;
            }
            for (List list : subchainsFromSupertype) {
                ClassUtils.addSubchain(subchains, subclass, list);
            }
        }
        return subchains;
    }

    private static <T> void addSubchain(Set<List<Class<? extends T>>> subchains, Class<? extends T> clazz, List<Class<? extends T>> subchainFromSupertype) {
        subchainFromSupertype.add(0, clazz);
        subchains.add(subchainFromSupertype);
    }

    static <S> List<Class<?>> getActualTypeArguments(Class<? extends S> typedClass, Class<S> typedSuperclass) {
        Preconditions.checkNotNull(typedSuperclass, (Object)"All arguments must be non-null");
        Preconditions.checkNotNull(typedClass, (Object)"All arguments must be non-null");
        if (!typedSuperclass.isAssignableFrom(typedClass)) {
            return null;
        }
        TypeVariable<Class<S>>[] typedClassTypeParams = typedSuperclass.getTypeParameters();
        if (typedClassTypeParams.length == 0) {
            return new ArrayList(0);
        }
        HashMap typeAssignments = new HashMap(typedClassTypeParams.length);
        List<Class<S>> superclassChain = ClassUtils.getSuperclassChain(typedClass, typedSuperclass);
        assert (superclassChain != null) : Arrays.asList(typedSuperclass, typedClass);
        for (int i = 0; i < superclassChain.size() - 1; ++i) {
            ClassUtils.collectAssignments(superclassChain.get(i), superclassChain.get(i + 1), typeAssignments);
        }
        return ClassUtils.getActualAssignments(typedClassTypeParams, typeAssignments);
    }

    private static void collectAssignments(Class<?> clazz, Class<?> supertype, Map<TypeVariable<?>, Class<?>> typeAssignments) {
        TypeVariable<Class<?>>[] typeParameters = supertype.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        Type[] actualTypeAttributes = ClassUtils.getActualTypeAttributes(clazz, supertype);
        assert (typeParameters.length == actualTypeAttributes.length) : Arrays.asList(typeParameters, typeAssignments);
        for (int i = 0; i < actualTypeAttributes.length; ++i) {
            Type type = actualTypeAttributes[i];
            if (type instanceof Class) {
                typeAssignments.put(typeParameters[i], (Class)type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                assert (((ParameterizedType)type).getRawType() instanceof Class) : type;
                typeAssignments.put(typeParameters[i], (Class)((ParameterizedType)type).getRawType());
                continue;
            }
            assert (type instanceof TypeVariable) : type;
            if (!typeAssignments.containsKey(type)) continue;
            typeAssignments.put(typeParameters[i], typeAssignments.get(type));
        }
    }

    private static Type[] getActualTypeAttributes(Class<?> clazz, Class<?> supertype) {
        Type genericSupertype = ClassUtils.tryGetGenericSupertype(clazz, supertype);
        return genericSupertype instanceof ParameterizedType ? ((ParameterizedType)genericSupertype).getActualTypeArguments() : supertype.getTypeParameters();
    }

    private static Type tryGetGenericSupertype(Class<?> clazz, Class<?> supertype) {
        if (!supertype.isInterface()) {
            return clazz.getGenericSuperclass();
        }
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        for (int i = 0; i < genericInterfaces.length; ++i) {
            Type interfaceType = genericInterfaces[i];
            if (interfaceType instanceof ParameterizedType && ((ParameterizedType)interfaceType).getRawType().equals(supertype)) {
                return interfaceType;
            }
            assert (interfaceType instanceof Class) : interfaceType;
            if (!interfaceType.equals(supertype)) continue;
            return interfaceType;
        }
        throw new AssertionError((Object)("Unable to find generic superclass information for class '" + clazz + "' and superclass/-interface '" + supertype + "'"));
    }

    private static List<Class<?>> getActualAssignments(TypeVariable<?>[] typedClassTypeParams, Map<TypeVariable<?>, Class<?>> typeAssignments) {
        int numTypedClassTypeParams = typedClassTypeParams.length;
        ArrayList actualAssignments = new ArrayList(numTypedClassTypeParams);
        for (int i = 0; i < numTypedClassTypeParams; ++i) {
            actualAssignments.add(typeAssignments.get(typedClassTypeParams[i]));
        }
        return actualAssignments;
    }
}

