package com.xebialabs.deployit.plugin.api.udm.base;

import static com.google.common.collect.Sets.newTreeSet;
import static com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts.scanPlaceholders;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;

/**
 * Represents an artifact.
 */
@SuppressWarnings("serial")
@Metadata(description = "Artifact.")
public abstract class BaseDeployableArtifact extends BaseDeployable implements DeployableArtifact, SourceArtifact {

	private OverthereFile file;

	@Property(description = "Placeholders detected in this artifact", required = false)
	private Set<String> placeholders = newTreeSet();

	@Property(description = "Regular expression that matches file names of text files", hidden = true, defaultValue =
										".+\\.(" +
										"cfg | conf | config | ini | properties | props | txt | " +
								        "asp | aspx | htm | html | jsf | jsp | xht | xhtml | " +
										"sql | " +
								        "xml | xsd | xsl | xslt" +
										")")
	private String textFileNamesRegex;

	@Property(required = false, defaultValue = "true")
	private boolean scanPlaceholders;

	public OverthereFile getFile() {
        return file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public Set<String> getPlaceholders() {
    	return placeholders;
    }

	public void setPlaceholders(Set<String> placeholders) {
    	this.placeholders = placeholders;
    }
	
	public String getTextFileNamesRegex() {
		return textFileNamesRegex;
	}

	public void setTextFileNamesRegex(String textFileNamesRegex) {
		this.textFileNamesRegex = textFileNamesRegex;
	}

	@Override
    public void initPlaceholders(PlaceholderScanner scanner) {
		scanPlaceholders(this, scanner);
    }

	public boolean isScanPlaceholders() {
		return scanPlaceholders;
	}

	public void setScanPlaceholders(boolean scanPlaceholders) {
		this.scanPlaceholders = scanPlaceholders;
	}
}
