/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.execution;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.InterleavedPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.ParallelPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.SerialPlan;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import java.util.Arrays;
import java.util.List;

public class Plans {
    public static InterleavedPlan interleaved(Delta ... operations) {
        return new InterleavedPlan(operations);
    }

    public static ParallelPlan parallel(Plan ... plans) {
        return new ParallelPlan(plans);
    }

    public static ParallelPlan parallel(List<Plan> plans) {
        return new ParallelPlan(plans);
    }

    public static SerialPlan serial(Plan ... plans) {
        return new SerialPlan(plans);
    }

    public static SerialPlan serial(List<Plan> plans) {
        return new SerialPlan(plans);
    }

    public static InterleavedPlan interleaved(List<DeploymentStep> steps) {
        return new InterleavedPlan(Lists.newArrayList(), steps);
    }

    public static InterleavedPlanBuilder newInterleavedPlan(InterleavedPlan original) {
        return new InterleavedPlanBuilder(original);
    }

    public static class InterleavedPlanBuilder {
        private List<Delta> operations;
        private List<DeploymentStep> steps;

        private InterleavedPlanBuilder(InterleavedPlan original) {
            this.operations = original.getDeltas();
            this.steps = Lists.newArrayList(original.getSteps());
        }

        public InterleavedPlanBuilder withStep(DeploymentStep step) {
            this.steps.add(step);
            return this;
        }

        public InterleavedPlanBuilder withSteps(List<DeploymentStep> steps) {
            this.steps.addAll(steps);
            return this;
        }

        public InterleavedPlanBuilder withSteps(DeploymentStep ... steps) {
            this.steps.addAll(Arrays.asList(steps));
            return this;
        }

        public InterleavedPlanBuilder replaceAllSteps(List<DeploymentStep> steps) {
            this.steps = steps;
            return this;
        }

        public InterleavedPlanBuilder clearSteps() {
            this.steps = Lists.newArrayList();
            return this;
        }

        public InterleavedPlanBuilder replaceStep(DeploymentStep old, DeploymentStep newStep) {
            if (this.steps.contains(old)) {
                int i = this.steps.indexOf(old);
                this.steps.remove(i);
                this.steps.add(i, newStep);
                return this;
            }
            throw new IllegalArgumentException("Could not find " + old + " in step list");
        }

        public InterleavedPlan build() {
            return new InterleavedPlan(this.operations, this.steps);
        }
    }
}

