package com.xebialabs.deployit.plugin.api.deployment.execution;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.sort;
import static java.util.Collections.unmodifiableList;

import java.util.List;

/**
 * A {@link CompositePlan} that executed steps in parallel.
 */
public class ParallelPlan extends CompositePlan {
    public ParallelPlan(Plan... plans) {
        super(plans);
    }

    public ParallelPlan(List<Plan> plans) {
        super(plans);
    }

	/**
	 * Returns the steps of all of the (parallel) sub-plans.
	 * The steps of all these plans are sorted together, as there is no happens-before order between plans.
	 *
	 * Sorting is done using the {@link StepComparator}.
	 * @return The sorted steps of all the sub-plans.
	 */
    @Override
    public List<DeploymentStep> getSteps() {

	    List<DeploymentStep> steps = newArrayList();
	    for (Plan plan : plans) {
		    steps.addAll(plan.getSteps());
	    }
	    // Sort them all as the plans run parallel.
		sort(steps, new StepComparator());

	    return unmodifiableList(steps);
    }
}
