/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SyntheticHelper {
    SyntheticHelper() {
    }

    static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = SyntheticHelper.getOptionalTypeAttribute(element, attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = SyntheticHelper.getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf(typeAttr);
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return SyntheticHelper.getOptionalTypeAttribute(element, attributeName, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return Boolean.valueOf(SyntheticHelper.getOptionalStringAttribute(element, attributeName, Boolean.toString(defaultValue)));
    }

    static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

    static List<Element> filterChildElementsByName(Element element, Predicate<String> matcher) {
        ArrayList children = Lists.newArrayList();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element e;
            if (!(childNodes.item(i) instanceof Element) || !matcher.apply((Object)(e = (Element)childNodes.item(i)).getNodeName())) continue;
            children.add(e);
        }
        return children;
    }

    static <E> void forEach(Collection<E> collection, Closure<E> closure) {
        for (E e : collection) {
            closure.call(e);
        }
    }

    public static interface Closure<E> {
        public void call(E var1);
    }
}

