/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.artifact;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.validation.FileEncodings;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.credentials.Credentials;
import com.xebialabs.deployit.plugin.proxy.ProxySettings;
import com.xebialabs.overthere.OverthereFile;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.NESTED;

@Metadata(virtual = true, inspectable = false, root = NESTED)
public class EmbeddedDeployableArtifact extends BaseEmbeddedDeployable implements SourceArtifact, TranscodableSourceArtifact {

    public static final String SCAN_PLACEHOLDERS_PROPERTY_NAME = "scanPlaceholders";

    private OverthereFile file;

    @Property(required = false, category = "Placeholders", description = "Whether to scan this artifact for placeholders when it is imported", defaultValue = "true")
    private boolean scanPlaceholders;

    @Property(required = false, category = "Placeholders", description = "Placeholders detected in this artifact")
    private Set<String> placeholders = new TreeSet<>();

    @Property(required = false, category = "Placeholders", description = "The delimiters used indicate placeholders, defaults to '{{ }}'. This is a 5 character string with a space in the middle, the first two are the leading delimiter, the last two are the closing delimiter",
            defaultValue = "{{ }}", hidden = true)
    @Regex(pattern = ".. ..")
    private String delimiters = "{{ }}";

    @Property(hidden = true, category = "Placeholders", description = "Regular expression that matches file names of text files", defaultValue =
            ".+\\.(" +
                    "cfg | conf | config | ini | properties | props | txt | " +
                    "asp | aspx | htm | html | jsf | jsp | xht | xhtml | " +
                    "sql | " +
                    "xml | xsd | xsl | xslt" +
                    ")")
    private String textFileNamesRegex;

    @Property(required = false, category = "Placeholders", description = "Regular expression that matches file names that must be excluded from scanning")
    private String excludeFileNamesRegex;

    @Property(required = false,
            category = "Transcode",
            label = "File Names Regex To Transcode",
            description = "Regular expression that matches file names of text files to transcode to EBCDIC", defaultValue =
            ".+\\.(" +
                    "cfg | conf | config | ini | properties | props | txt | " +
                    "asp | aspx | htm | html | jsf | jsp | xht | xhtml | " +
                    "sql | " +
                    "xml | xsd | xsl | xslt" +
                    ")")
    private String textFileNamesRegexToTranscode;


    @Property(required = false,
            category = "Transcode",
            label = "Exclude File Names Regex To Transcode",
            description = "A regex of file type that needs to be ignored for transcode",
            defaultValue = "")
    private String excludeFileNamesRegexToTranscode;

    @Property(required = false, category = "Deployment", description = "The checksum used to detect differences on the artifact. If not provided, it will be calculated by XL Deploy.")
    private String checksum;

    @Property(required = false,
            category = "Placeholders",
            description = "Specifies file encodings in this artifact. Key: regular expression matching file names; value: character set. Character set encoding is used for placeholder replacement and transcoding files to z/OS.",
            defaultValue =  ".+\\.properties:ISO-8859-1")
    @FileEncodings
    private Map<String, String> fileEncodings;

    @Property(required = false, description = "The URI pointing to the (remote) location of the file this artifact represents")
    private String fileUri;

    @Property(required = false, description = "Credentials")
    private Credentials credentials;

    @Property(required = false, description = "Credentials")
    private ProxySettings proxySettings;

    public OverthereFile getFile() {
        return file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public boolean isScanPlaceholders() {
        return scanPlaceholders;
    }

    public void setScanPlaceholders(boolean scanPlaceholders) {
        this.scanPlaceholders = scanPlaceholders;
    }

    public Set<String> getPlaceholders() {
        return placeholders;
    }

    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }

    public String getTextFileNamesRegex() {
        return textFileNamesRegex;
    }

    public void setTextFileNamesRegex(String textFileNamesRegex) {
        this.textFileNamesRegex = textFileNamesRegex;
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return excludeFileNamesRegex;
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return fileEncodings;
    }

    @Override
    public String getFileUri() {
        return fileUri;
    }

    @Override
    public Credentials getCredentials() {
        return credentials;
    }

    @Override
    public ProxySettings getProxySettings() {
        return proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public void setExcludeFileNamesRegex(String excludeFileNamesRegex) {
        this.excludeFileNamesRegex = excludeFileNamesRegex;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getDelimiters() {
        return delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }


    @Override
    public String getTextFileNamesRegexToTranscode() {
        return textFileNamesRegexToTranscode;
    }

    public void setTextFileNamesRegexToTranscode(String textFileNamesRegexToTranscode) {
        this.textFileNamesRegexToTranscode = textFileNamesRegexToTranscode;
    }

    @Override
    public String getExcludeFileNamesRegexToTranscode() {
        return excludeFileNamesRegexToTranscode;
    }

    public void setExcludeFileNamesRegexToTranscode(String excludeFileNamesRegexToTranscode) {
        this.excludeFileNamesRegexToTranscode = excludeFileNamesRegexToTranscode;
    }


}
