/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import static java.lang.String.format;
import static java.lang.System.identityHashCode;

/**
 * Default implementation of a {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem} that provides id, name and type information.
 */
@Metadata(virtual = true, description="Default implementation of a CI that provides ID, name and type information.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class BaseConfigurationItem implements ConfigurationItem, Comparable<BaseConfigurationItem> {

    protected String id = String.valueOf(identityHashCode(this));
    protected Type type = Type.valueOf(this.getClass());
    protected Map<String, Object> syntheticProperties = new HashMap<>();
    private Map<String, ExternalProperty> $externalProperties = new HashMap<>();
    private String $token;
    private CiAttributes $ciAttributes = new CiAttributes(null, null, null, null, null);
    private Integer $internalId;
    private Integer $securedCi;

    private String $directoryReference;
    private String $securedDirectoryReference;
    private String $referenceId;

    private List<ValidationMessage> $validationMessages = new ArrayList<>();

    @Override
    @PublicApiMember
    public String getId() {
        return id;
    }

    @Override
    @PublicApiMember
    public void setId(String id) {
        if (id != null && id.length() > 0 && id.charAt(id.length() - 1) == '/') {
            id = id.substring(0, id.length() - 1);
        }
        this.id = id;
    }

    @Override
    public String getName() {
        int indexOfLastSlash = id.lastIndexOf('/');
        if (indexOfLastSlash > -1) {
            return id.substring(indexOfLastSlash + 1);
        }
        return id;
    }

    @Override
    @PublicApiMember
    public Type getType() {
        return type;
    }

    /**
     * Sets the type metadata for this CI.
     */
    @PublicApiMember
    public void setType(Type type) {
        this.type = type;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getProperty(String key) {
        return (T) getPropertyDescriptor(key).get(this);
    }

    @Override
    public boolean hasProperty(String key) {
        return type.getDescriptor().getPropertyDescriptor(key) != null;
    }

    @Override
    public <T> void setProperty(String key, T value) {
        getPropertyDescriptor(key).set(this, value);
    }

    /**
     * @return attributes of ci modification.
     */
    public CiAttributes get$ciAttributes() {
        return $ciAttributes;
    }

    /**
     * Sets attributes of ci modification.
     *
     * @param $ciAttributes attributes of ci modification
     */
    public void set$ciAttributes(CiAttributes $ciAttributes) {
        this.$ciAttributes = $ciAttributes;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = type.getDescriptor().getPropertyDescriptor(name);
        if (pd == null) {
            throw new IllegalArgumentException(format("Type %s has no property %s", type, name));
        }
        return pd;
    }

    /**
     * @return The JCR optimistic locking token.
     */
    public String get$token() {
        return $token;
    }

    /**
     * @param $token The JCR optimistic locking token.
     */
    public void set$token(String $token) {
        this.$token = $token;
    }

    @Override
    public List<ValidationMessage> get$validationMessages() {
        return $validationMessages;
    }

    public void set$validationMessages(List<ValidationMessage> $validationMessages) {
        this.$validationMessages = $validationMessages;
    }

    public Map<String, ExternalProperty> get$externalProperties() {
        return $externalProperties;
    }

    public void set$externalProperties(Map<String, ExternalProperty> externalProperties) {
        this.$externalProperties = externalProperties;
    }

    public Integer get$internalId() {
        return $internalId;
    }

    public void set$internalId(final Integer internalId) {
        this.$internalId = internalId;
    }

    public Integer get$securedCi() {
        return $securedCi;
    }

    public void set$securedCi(Integer securedCi) {
        this.$securedCi = securedCi;
    }

    @Override
    public String get$directoryReference() {
        return $directoryReference;
    }

    public void set$directoryReference(String $directoryReference) {
        this.$directoryReference = $directoryReference;
    }

    public String get$securedDirectoryReference() {
        return $securedDirectoryReference;
    }

    public void set$securedDirectoryReference(String $securedDirectoryReference) {
        this.$securedDirectoryReference = $securedDirectoryReference;
    }

    @Override
    public String get$referenceId() { return $referenceId; }

    public void set$referenceId(String $referenceId) {
        this.$referenceId = $referenceId;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (this == thatObject)
            return true;
        if (!(thatObject instanceof BaseConfigurationItem))
            return false;
        if(getId() == null)
            return false;

        BaseConfigurationItem that = (BaseConfigurationItem) thatObject;
        return getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : identityHashCode(this);
    }

    @Override
    public int compareTo(BaseConfigurationItem o) {
        return getId().compareTo(o.getId());
    }

    @Override
    public String toString() {
        if (id == null) {
            return getClass().getName() + "[id = null]";
        }
        if (Pattern.matches("[ '\"]", id)) {
            return "\"" + id + "\"";
        }
        return id;
    }

}
