/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Enumeration of all the available values for a property's type.
 */
@PublicApiRef
public enum PropertyKind {
    BOOLEAN(true),

    INTEGER(true),

    LONG(true),

    STRING(true),

    ENUM(true),

    DATE(true),

    CI,

    SET_OF_STRING, SET_OF_CI,
    
    LIST_OF_STRING, LIST_OF_CI,

    MAP_STRING_STRING;

    private boolean simple;

    PropertyKind() {
    }

    PropertyKind(boolean simple) {
        this.simple = simple;
    }

    /**
     * @return Whether this kind can be safely treated as a PropertyKind.STRING when doing placeholder resolution.
     */
    public boolean isSimple() {
        return simple;
    }
}
