/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import java.io.Serializable;
import org.joda.time.DateTime;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * A container for metadata about CI's
 */
@PublicApiRef
public class CiAttributes implements Serializable {
    private String createdBy;
    private String lastModifiedBy;
    private DateTime createdAt;
    private DateTime lastModifiedAt;
    private String scmTraceabilityDataId;

    /**
     * Constructs a CiAttributes object with the given parameters
     * @param createdBy - the original creator of the CI
     * @param createdAt - the creation date of the CI
     * @param lastModifiedBy - the user that last modified the CI
     * @param lastModifiedAt - the last modification date for the CI
     * @param scmTraceabilityDataId - id of scm traceability data
     */
    public CiAttributes(String createdBy, DateTime createdAt, String lastModifiedBy, DateTime lastModifiedAt, String scmTraceabilityDataId) {
        this.createdBy = createdBy;
        this.lastModifiedBy = lastModifiedBy;
        this.createdAt = createdAt;
        this.lastModifiedAt = lastModifiedAt;
        this.scmTraceabilityDataId = scmTraceabilityDataId;
    }

    /**
     * Get the name of the user that originally created this CI
     * @return a String
     */
    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * The original creation date of this CI
     * @return a Calendar
     */
    public DateTime getCreatedAt() {
        return createdAt;
    }

    /**
     * Get the name of the user that last modified something about this CI
     * @return a String
     */
    public String getLastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Get the last modification date for this CI
     * @return a Calendar
     */
    public DateTime getLastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * Get the id of scm traceability data
     * @return an Integer
     */
    public String getScmTraceabilityDataId() {
        return scmTraceabilityDataId;
    }

    /**
     * Set the id of scm traceability data
     * @param scmTraceabilityDataId new data id
     */
    public void setScmTraceabilityDataId(String scmTraceabilityDataId) {
        this.scmTraceabilityDataId = scmTraceabilityDataId;
    }
}
