/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;

import static com.xebialabs.xlplatform.utils.Strings.mkString;
import static java.util.stream.Collectors.toList;

@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = ApplicationDependenciesFormat.Validator.class, type = "applicationDependencies")
@ApplicableTo(PropertyKind.MAP_STRING_STRING)
public @interface ApplicationDependenciesFormat {
    String DEFAULT_MESSAGE_WRONG_APPLICATION = "Application names should be used instead of paths: '%s'.";

    class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Map<String, String>> {

        private String messageWrongApplication = DEFAULT_MESSAGE_WRONG_APPLICATION;

        @Override
        public void validate(final Map<String, String> value, final ValidationContext context) {
            if (value == null) return;
            List<String> invalidApplicationNames = value.keySet().stream().filter(Validator::nameInvalid).collect(toList());
            if (!invalidApplicationNames.isEmpty()) {
                context.error(String.format(messageWrongApplication, mkString(invalidApplicationNames, "', '")));
            }
        }

        private static boolean nameInvalid(final String name) {
            return name == null || name.contains("/");
        }
    }
}
