/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.rules;

/**
 * Please refer to rules manual for explanation of what a scope is.
 */
public enum Scope {
    DEPLOYED("deployed"),
    PLAN("plan"),
    PRE_PLAN("pre-plan"),
    POST_PLAN("post-plan");

    private String scopeName;

    private Scope(String scopeName) {
        this.scopeName = scopeName;
    }

    public String getScopeName() {
        return scopeName;
    }

    @Override
    public String toString() {
        return scopeName;
    }

    public static Scope getScope(String scopeName) {
        for (Scope scope : Scope.values()) {
            if (scope.getScopeName().equals(scopeName)) {
                return scope;
            }
        }
        throw new IllegalArgumentException(String.format("Could not find scope for name [%s]", scopeName));
    }
}
