/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.rules;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Marks a method of {@link com.xebialabs.deployit.plugin.api.flow.Step} to be executed to for post construct actions.
 * The method will be called only in case a step is created within a rule.
 * Method must accept a single argument of type {@link com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext}
 */
@Documented
@Retention(RUNTIME)
@Target(METHOD)
public @interface RulePostConstruct {
}
