/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import java.lang.annotation.*;

/**
 * A delegate can execute either:
 *   - a control task on a {@link ConfigurationItem}, to perform some action.
 *   - a creator method when creating a {@link ConfigurationItem}
 * <p/>
 * A @Delegate method should adhere to the following rules:
 * <ul>
 *     <li> For Control Task:
 *         <ul>
 *             <li>The constructor of the object should take no arguments</li>
 *             <li>The method should take the following 3 parameters:
 *             <ol>
 *                 <li>A ConfigurationItem (The item the method is invoked on).</li>
 *                 <li>A String (the name of the method invoked).</li>
 *                 <li>A Map&lt;String, String&gt; (The attributes of the method invoked).</li>
 *             </ol>
 *             </li>
 *             <li>The method should return a List&lt;{@link com.xebialabs.deployit.plugin.api.flow.Step}&gt;</li>
 *         </ul>
 *     </li>
 *     <li> For Creator:
 *         <ul>
 *             <li>The method should be static</li>
 *             <li>The method should take the following 1 or 2 parameters:
 *             <ol>
 *                 <li>A CreatorContext.</li>
 *                 <li>Optional: A Map&lt;String, String&gt; (The attributes of the method invoked).</li>
 *             </ol>
 *             </li>
 *             <li>The method should return void.</li>
 *         </ul>
 *     </li>
 * </ul>
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface Delegate {
    String name();

    Use use() default Use.CONTROL_TASK;

    enum Use {
        CONTROL_TASK,
        CREATOR
    }
}
