/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * A super type for both {@link Deployed}s and {@link EmbeddedDeployed}s.
 *
 * Deployeds are configuration items (CIs) that represent {@link Deployable}s CIs in their deployed form.
 *
 * @param <D> The type for the deployable CI.
 * @param <C> The type for the container CI.
 */
@PublicApiRef
public interface EmbeddedDeployedContainer<D extends ConfigurationItem, C extends ConfigurationItem> extends ConfigurationItem {
    String DEPLOYABLE_FIELD = "deployable";
    String CONTAINER_FIELD = "container";

    /**
     * @return The associated {@link Deployable} CI.
     */
    D getDeployable();

    /**
     * @param deployable The associated {@link Deployable} CI.
     */
    void setDeployable(D deployable);

    /**
     * @return The target {@link Container}.
     */
    C getContainer();

    /**
     * @param container The target {@link Container}.
     */
    void setContainer(C container);

}
