/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.ArrayList;
import java.util.List;

@PublicApiRef
@Metadata(virtual = true, description = "Base type for all provisionables.")
public class BaseProvisionable extends BaseDeployable implements Provisionable {

    @Property(required = false, description = "Number of instances to launch.", defaultValue = "1", hidden = true)
    private String cardinality = "1";

    @Property(description = "A list of provisioners associated with the instance.", required = false, asContainment = true)
    private List<Provisioner> provisioners = new ArrayList<>();

    public BaseProvisionable() {
    }

    public String getCardinality() {
        return cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public List<Provisioner> getProvisioners() {
        return provisioners;
    }

    public void setProvisioners(List<Provisioner> provisioners) {
        this.provisioners = provisioners;
    }
}
