/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.proxy

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}

import scala.beans.BeanProperty

@Metadata(root = CONFIGURATION, description = "Proxy configuration")
@TypeIcon(value = "icons/types/lock.svg")
class ProxyServer extends BaseConfigurationItem with ProxySettings {

  @Property(description = "Proxy protocol.", size = Property.Size.SMALL, label = "Proxy protocol", defaultValue = "HTTP")
  @BeanProperty
  var protocol: ProxyServerType = _

  @Property(description = "Proxy hostname.", size = Property.Size.SMALL, label = "Hostname")
  @BeanProperty
  var hostname: String = _

  @Property(description = "Proxy port.", size = Property.Size.SMALL, label = "Port", defaultValue = "80")
  @BeanProperty
  var port: Integer = _

  @Property(label = "User name", required = false)
  @BeanProperty
  var username: String = _

  @Property(label = "Password", required = false, password = true)
  @BeanProperty
  var password: String = _

}
