/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashSet;
import java.util.Set;

@PublicApiRef
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all Containers.")
public class BaseContainer extends BaseConfigurationItem implements Container {

    @Property(required = false, category = "Deployment", description = "If set, only deployables with the same tag will be automatically mapped to this container.")
    private Set<String> tags = new HashSet<>();

    @Override
    public Set<String> getTags() {
        return tags;
    }

    @Override
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }
}
