/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Implementation of a {@link BaseConfigurationItem} that provides on success policy.
 */
@SuppressWarnings("serial")
@Metadata(virtual = true, description="Implementation of a Base CI that provides on success policy.")
@PublicApiRef
public class BaseConfigurationItemWithPolicies extends BaseConfigurationItem {

    @Property(
            description = "Process successful tasks on CI according to the defined policy.",
            required = false,
            category = "Policies"
    )
    protected OnTaskSuccessPolicy onSuccessPolicy;

    @Property(
            description = "Process failed tasks on CI according to the defined policy.",
            required = false,
            category = "Policies"
    )
    protected OnTaskFailurePolicy onFailurePolicy;

    /**
     * @return task success policy.
     */
    public OnTaskSuccessPolicy getOnSuccessPolicy() {
        return onSuccessPolicy != null ? onSuccessPolicy : OnTaskSuccessPolicy.NOOP;
    }

    /**
     * Sets on task success policy.
     *
     * @param onSuccessPolicy attributes of ci modification
     */
    public void setOnSuccessPolicy(OnTaskSuccessPolicy onSuccessPolicy) {
        this.onSuccessPolicy = onSuccessPolicy;
    }

    /**
     * @return task failure policy.
     */
    public OnTaskFailurePolicy getOnFailurePolicy() {
        return onFailurePolicy != null ? onFailurePolicy : OnTaskFailurePolicy.NOOP;
    }

    /**
     * Sets on task failure policy.
     *
     * @param onFailurePolicy attributes of ci modification
     */
    public void setOnFailurePolicy(OnTaskFailurePolicy onFailurePolicy) {
        this.onFailurePolicy = onFailurePolicy;
    }
}
