/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.satellite

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.INFRASTRUCTURE

import scala.beans.{BeanProperty, BooleanBeanProperty}

@Metadata(root = INFRASTRUCTURE, description = "XL satellite configuration item.")
@TypeIcon(value = "icons/types/xl.Satellite.svg")
class Satellite extends BaseContainer {
  @Property(description = "Address where the satellite can be reached.", size = Property.Size.MEDIUM, label = "Address")
  @BeanProperty
  var address: String = _

  @Property(description = "Port where the satellite is listening.", size = Property.Size.SMALL, label = "Port")
  @BeanProperty
  var protocolPort: Integer = _

  @BooleanBeanProperty
  @Property(description = "Enable encrypted communication.", label = "Encryption", required = false)
  var encrypted = false

  def collectSatellites(): Set[Satellite] = Set(this)

}
