/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.flow;

import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;

public interface StagingContext {
    /**
     * Stage a local file (artifact) to be copied to a remote host.
     *
     * @param artifact The artifact to be staged
     * @param target The target that the artifact will be copied to
     * @return A staged file that is either uploaded early (staged) or just in time
     */
    StagedFile stageArtifact(Artifact artifact, StagingTarget target);
}
