/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.validation.NoSelfReference;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * A {@link Version} of an {@link Application} which can contain a list of other {@link Version}s,
 * as well as artifacts and resource specifications (a collection of {@link Deployable}s) that can be deployed onto
 * a {@link Container}.
 *
 * Please note that the word <i>package</i> can be used to refer to a {@link Version}. In this case the definition
 * makes more sense, as a CompositePackage can contain a list of other packages.
 *
 * @deprecated Using dependencies and multi-application deployments you can now do what you previously needed udm.CompositePackage s for.
 */
@PublicApiRef
@SuppressWarnings("serial")
@Metadata(description="(Deprecated) A container of DeploymentPackages that is a DeploymentPackage itself. ")
@NoSelfReference(referenceField = "packages")
@Deprecated
public class CompositePackage extends Version {


    @Property(required = false, description = "The DeploymentPackages that make up this CompositePackage.")
    private List<Version> packages = new ArrayList<>();

    /**
     * @return The list of member packages ({@link Version} objects).
     */
    public List<Version> getPackages() {
        return packages;
    }

    /**
     * @return A collection of artifacts and resource specifications ({@link Deployable} objects)
     */
    @Override
    public Set<Deployable> getDeployables() {
        Set<Deployable> d = new HashSet<>();
        for (Version aPackage : packages) {
            d.addAll(aPackage.getDeployables());
        }
        return d;
    }
}
