/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.satellite

import java.util.{HashSet => JHashSet, Set => JSet}
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.INFRASTRUCTURE

import scala.beans.BeanProperty
import scala.jdk.CollectionConverters.SetHasAsScala

@Metadata(root = INFRASTRUCTURE, description = "XL satellite group configuration item.")
@TypeIcon(value = "icons/types/xl.SatelliteGroup.svg")
class SatelliteGroup extends Satellite {
  @BeanProperty
  var chosenSatellite: Satellite = _

  @Property(required = false)
  private val satellites: JSet[Satellite] = new JHashSet[Satellite]

  def getSatellites: JSet[Satellite] = satellites

  override def getAddress: String = getChosenSatelliteProp(_.getAddress)

  override def getProtocolPort: Integer = getChosenSatelliteProp(_.getProtocolPort)

  override def isEncrypted: Boolean = getChosenSatelliteProp(_.isEncrypted)

  override def collectSatellites(): Set[Satellite] = satellites.asScala.flatMap(_.collectSatellites()).toSet

  private[this] def getChosenSatelliteProp[A](f: Satellite => A): A =
    Option(chosenSatellite).map(f).getOrElse(throw new IllegalStateException(s"No Satellite chosen for $this"))
}
