/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashSet;
import java.util.Set;

/**
 * Anything that is deployable to a {@link Container}
 */
@PublicApiRef
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all Deployables.")
public class BaseDeployable extends BaseConfigurationItem implements Deployable {

    @Property(description = "The set of CI templates.", asContainment = false, required = false, candidateValuesFilter = "filterByProvisioningPackage", hidden = true)
    private Set<Template> boundTemplates = new HashSet<>();

    @Property(required = false, category = "Deployment", description = "If set, this deployable will only be mapped automatically to containers with the same tag.")
    private Set<String> tags = new HashSet<>();

    @Override
    public Set<String> getTags() {
        return tags;
    }

    @Override
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<Template> getBoundTemplates() {
        return boundTemplates;
    }

    public void setBoundTemplates(Set<Template> boundTemplates) {
        this.boundTemplates = boundTemplates;
    }
}
