/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.credentials

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem

import scala.beans.{BeanProperty, BooleanBeanProperty}

@Metadata(root = CONFIGURATION, description = "User name password credentials")
@TypeIcon(value = "icons/types/lock.svg")
class UsernamePasswordCredentials extends BaseConfigurationItem with Credentials {

  @Property(label = "User name")
  @BeanProperty
  var username: String = _

  @Property(password = true, label = "Password")
  @BeanProperty
  var password: String = _

}
