/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.Map;

/**
 * Encapsulates the metadata about the creator of a type in the XL Deploy type system.
 *
 * Creators allow actions to be executed on CIs when they are created.
 *
 * Arguments are configured in the control task definition in the synthetic.xml file. Arguments are specified as
 * attributes on the synthetic method definition XML and are passed as-is to the control task.
 */
@PublicApiRef
public interface CreatorDescriptor {

    /**
     * @return The name of the method if class based or delegate name if synthetic based.
     */
    String getName();

    /**
     * @return A map of arguments to be passed to the method call. An entry key represents the name of the argument,
     * and an entry value is the value of the argument.
     */
    Map<String, String> getAttributes();

    /**
     * @param context The {@link CreatorContext} on which to invoke the creator.
     */
    void invoke(CreatorContext context);

    /**
     * @return The fully qualified name of the creator. This is the type name followed by a dot and then
     * the creator name. For example: k8s.ResourcesFile.creator
     */
    String getFqn();

}
