/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.planning;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

/**
 * A read-only view of the XL Deploy repository.
 * 
 * <em>Note:</em> You cannot store a reference to the read-only repository in a Step, as it is not serializable, and the connection to the repository is not restored.
 * @deprecated Replaced by {@link com.xebialabs.deployit.plugin.api.services.Repository}
 */
@Deprecated
public interface ReadOnlyRepository {
    /**
     * Read a {@link ConfigurationItem} with a specific id.
     * 
     * @param id
     *          The id of the {@link ConfigurationItem} to read.
     *          
     * @return The read {@link ConfigurationItem}
     */
    <T extends ConfigurationItem> T read(String id);

    /**
     * Search for all {@link ConfigurationItem}s of the specified {@link Type}.
     * @param type
     *          The {@link Type} of the {@link ConfigurationItem}s to search for.
     * @return A {@link List} of {@link ConfigurationItem}s of the {@link Type} passed in.
     */
    <T extends ConfigurationItem> List<T> search(Type type);

    /**
     * Search for all {@link ConfigurationItem}s of the specified {@link Type} under a parent node
     *
     * @param type
     *          The {@link Type} of the {@link ConfigurationItem}s to search for.
     *
     * @param parent
     *          The id of the parent node under which to search.
     *
     * @return A {@link List} of {@link ConfigurationItem}s of the {@link Type} which are located under the parent node.
     */
    <T extends ConfigurationItem> List<T> search(Type type, String parent);
}
