/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.*;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.NESTED;

@SuppressWarnings({ "serial", "rawtypes" })
@Metadata(virtual = true, description = "The supertype of all EmbeddedDeployeds.", inspectable = false, root = NESTED)
public class BaseEmbeddedDeployed<D extends EmbeddedDeployable, C extends EmbeddedDeployedContainer> extends BaseConfigurationItem implements EmbeddedDeployed<D, C> {

    @Property(required = false, description = "The embedded deployable that this embedded deployed is derived from.")
    @DeployedSpecific
    private D deployable;

    @Property(asContainment = true, description = "The (embedded) deployed which contains this embedded deployed.")
    @DeployedSpecific
    private C container;

    /**
     * Default constructor should be public in order to be able to instantiate this.
     */
    public BaseEmbeddedDeployed() {
    }

    protected BaseEmbeddedDeployed(D deployable, C container) {
        this.deployable = deployable;
        this.container = container;
    }

    @Override
    public D getDeployable() {
        return deployable;
    }

    @Override
    public void setDeployable(D deployable) {
        this.deployable = deployable;
    }

    @Override
    public C getContainer() {
        return container;
    }

    @Override
    public void setContainer(C container) {
        this.container = container;
    }
}
