/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.planning;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;

/**
 * Defines a checkpoint for the execution of a deployment.
 */
public final class Checkpoint {
    private Delta deltaToCheckpoint;
    private String intermediateCheckpointName;
    private Operation overrideOperation;

    /**
     * @param deltaToCheckpoint The Delta that needs to be checkpointed.
     */
    public Checkpoint(Delta deltaToCheckpoint) {
        this(deltaToCheckpoint, null, null);
    }

    public Checkpoint(Delta deltaToCheckpoint, String intermediateCheckpointName, Operation overrideOperation) {
        this.deltaToCheckpoint = deltaToCheckpoint;
        this.intermediateCheckpointName = intermediateCheckpointName;
        this.overrideOperation = _correctOperation(deltaToCheckpoint, overrideOperation);
    }

    private Operation _correctOperation(Delta deltaToCheckpoint, Operation overrideOperation) {
        return overrideOperation == null ? deltaToCheckpoint.getOperation() : overrideOperation;
    }

    public Delta getDeltaToCheckpoint() {
        return deltaToCheckpoint;
    }

    public String getIntermediateCheckpointName() {
        return intermediateCheckpointName;
    }

    public Operation getOverrideOperation() {
        return overrideOperation;
    }
}
