/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Verify(clazz=Validator.class, type="isControlTaskParameters")
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface IsControlTaskParameters {

    public static class Validator
    implements TypeVerification {
        @Override
        public void verify(Descriptor descriptor, VerificationContext context) {
            Type type = descriptor.getType();
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                this.validate(!propertyDescriptor.isAsContainment(), context, propertyDescriptor.getName(), type, "asContainment");
                this.validate(!propertyDescriptor.isHidden(), context, propertyDescriptor.getName(), type, "hidden");
                this.validate(!propertyDescriptor.isInspectionProperty(), context, propertyDescriptor.getName(), type, "inspection property");
                this.validate(!propertyDescriptor.isRequiredForInspection(), context, propertyDescriptor.getName(), type, "required for inspection");
            }
        }

        private void validate(boolean b, VerificationContext context, Object ... params) {
            if (!b) {
                context.error("Property [%s] of [%s] cannot be marked as %s.", params);
            }
        }
    }
}

