/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatActiveMQConnectionFactory;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;

public class CreateTomcatActiveMQConnectionFactoryStep
extends TomcatStepBase {
    private TomcatActiveMQConnectionFactory amqcf;

    public CreateTomcatActiveMQConnectionFactoryStep(TomcatUnmanagedServer server, TomcatActiveMQConnectionFactory amqcf, TomcatWarMapping mapping) {
        super(server, mapping);
        this.amqcf = amqcf;
        this.setDescription("Create AMQ Connection Factory " + (Object)((Object)amqcf) + " on Tomcat server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile dsFile = s.getFile(this.getContextFilePathOnServer());
            ctx.logOutput("Creating AMQ Connection Factory definition in context file " + dsFile.getPath() + " on " + this.server.getHost());
            TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(dsFile);
            contextFileUtils.addOrUpdateTomcatActiveMQConnectionFactory(this.amqcf);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

