/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WarMappingBasedTomcatServerMapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends TomcatUnmanagedServer>
extends StepGeneratingMapper<S, M, T> {
    private Mapper<War, TomcatWarMapping, T>[] tomcatServerMappers;

    public WarMappingBasedTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, T> ... tomcatServerMappers) {
        super(change);
        this.tomcatServerMappers = tomcatServerMappers;
    }

    protected void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
        Set<TomcatWarMapping> addedAndModifiedWarMappings = this.getAddedAndModifiedWarMappings();
        for (TomcatWarMapping warMapping : addedAndModifiedWarMappings) {
            if (!((TomcatServer)((Object)warMapping.getTarget())).equals(newMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                this.generateAdditionStepsForAddedMapping(newMappingSource, newMapping, newMappingTarget, warMapping, steps);
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    protected abstract void generateAdditionStepsForAddedMapping(S var1, M var2, T var3, TomcatWarMapping var4, List<Step> var5);

    protected abstract void generateDeletionStepsForDeletedMapping(S var1, M var2, T var3, TomcatWarMapping var4, List<Step> var5);

    protected void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, List<Step> steps) {
        Set<TomcatWarMapping> deletedAndModifiedMappings = this.getdeletedAndModifiedWarMappings();
        for (TomcatWarMapping warMapping : deletedAndModifiedMappings) {
            if (!((TomcatServer)((Object)warMapping.getTarget())).equals(oldMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                this.generateDeletionStepsForDeletedMapping(oldMappingSource, oldVersionOfModifiedMapping, oldMappingTarget, warMapping, steps);
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    private Set<TomcatWarMapping> getdeletedAndModifiedWarMappings() {
        HashSet warMappings = Sets.newHashSet();
        for (Mapper<War, TomcatWarMapping, T> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getOldMappings());
        }
        return warMappings;
    }

    private Set<TomcatWarMapping> getAddedAndModifiedWarMappings() {
        HashSet warMappings = Sets.newHashSet();
        for (Mapper<War, TomcatWarMapping, T> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getNewMappings());
        }
        return warMappings;
    }
}

