package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

import java.util.List;

/**
 *
 */
public class DeleteTomcatResourceLinksStep extends TomcatStepBase implements Step {
	private List<ResourceLink> resources;

	public DeleteTomcatResourceLinksStep(TomcatUnmanagedServer target, String label, TomcatWarMapping warMapping, List<ResourceLink> resources) {
		super(target,warMapping);
		this.resources = resources;
		setDescription("Delete Global JNDI Resources based on " + label + " on Tomcat server " + server + " on context "+contextRoot);
	}

	public boolean execute(StepExecutionContext ctx) {
		return false;  //To change body of implemented methods use File | Settings | File Templates.
	}

	public List<ResourceLink> getResources() {
		return resources;
	}
}
